const express = require('express');
const path = require('path');
const cookieParser = require('cookie-parser');
const logger = require('morgan');
const cors = require('cors');
// const bodyParser = require('body-parser');

const indexRouter = require('./app/routes/index');
const gradoRouter = require('./app/routes/grado.routes');
const trofeoRouter = require('./app/routes/trofeo.routes');
const profesorRouter = require('./app/routes/profesor.routes');
const estudianteRouter = require('./app/routes/estudiante.routes');
const tipoRouter = require('./app/routes/tipo.routes');
const libroRouter = require('./app/routes/libro.routes');
const parrafoRouter = require('./app/routes/parrafo.routes');
const cuestionarioRouter = require('./app/routes/cuestionario.routes');
const obtencionRouter = require('./app/routes/obtencion.routes');
const publicacionRouter = require('./app/routes/publicacion.routes');
const libroexternoRouter = require('./app/routes/libroexterno.routes');
const progresoRouter = require('./app/routes/progreso.routes');
const resolucionRouter = require('./app/routes/resolucion.routes');

const app = express();

app.use(cors()); //acepta todos los origenes
// app.use(cors({
//   origin: 'http://localhost:4200',
//   optionsSuccessStatus: 200 // some legacy browsers (IE11, various SmartTVs) choke on 204
// }));
app.use((req, res, next) => {
    // Website you wish to allow to connect
  res.setHeader('Access-Control-Allow-Origin', '*');
  // Request methods you wish to allow
  res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
  // Request headers you wish to allow
  res.setHeader('Access-Control-Allow-Headers', 'Access-Control-Allow-Headers, Origin,Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers,X-Access-Token,XKey,Authorization');
//  res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
  // Pass to next layer of middleware
  next();
  });
app.use(logger('dev'));
app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use(cookieParser());
// app.use(bodyParser.urlencoded({extended: false}));
// app.use(bodyParser.json());
app.use('/uploads', express.static(path.resolve('uploads')));
app.use('/', express.static(path.join(__dirname, 'public')));

app.use('/live', indexRouter);
app.use('/grado', gradoRouter);
app.use('/trofeo', trofeoRouter);
app.use('/profesor', profesorRouter);
app.use('/estudiante', estudianteRouter);
app.use('/obtencion', obtencionRouter);
app.use('/tipo', tipoRouter);
app.use('/libro', libroRouter);
app.use('/parrafo', parrafoRouter);
app.use('/cuestionario', cuestionarioRouter);
app.use('/publicacion', publicacionRouter); // aca hay error
app.use('/libroexterno', libroexternoRouter);
app.use('/progreso', progresoRouter);
app.use('/resolucion', resolucionRouter);

module.exports = app;