const db = require('../models');
const Cuestionario = db.Cuestionario;

exports.list = async function(req, res) {
  try {
    const Cuestionarios = await Cuestionario.findAll(
      {
        attributes: [
          'id',
          'Pregunta',
          'RespuestaCorrecta',
          'RespuestaIncorrecta1',
          'RespuestaIncorrecta2',
          'LibroId'
        ],
        include: [
          {
            model: db.Libro,
            as: 'libro',
            attributes:
            [
              'id',
              'Titulo',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(Cuestionarios);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// preguntas del libro
exports.getcuestionbook = async function(req, res) {
  try {
    const parametro = req.params.libro;
    const preguntas = await Cuestionario.findAll(
      {
        where: {
          LibroId: parametro
        },
        attributes: [
          'id',
          'Pregunta',
          'RespuestaCorrecta',
          'RespuestaIncorrecta1',
          'RespuestaIncorrecta2',
          'LibroId'
        ],
        include: [
          {
            model: db.Libro,
            as: 'libro',
            attributes:
            [
              'id',
              'Titulo',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(preguntas);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.get = async function(req, res) {
  try {
    const id = req.params.id;
    const cuestionario = await Cuestionario.findOne(
      {
        where: {
          id: id
        },
        attributes: [
          'id',
          'Pregunta',
          'RespuestaCorrecta',
          'RespuestaIncorrecta1',
          'RespuestaIncorrecta2',
          'LibroId'
        ],
        include: [
          {
            model: db.Libro,
            as: 'libro',
            attributes:
            [
              'id',
              'Titulo',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(cuestionario);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// POST /productos/
exports.create = async function(req, res) {
  try{
      const nuevoCuestionario = await Cuestionario.create(req.body);
      res.json(nuevoCuestionario);
  } catch(err){
      res.status(500).json({error: err});
  }
};

// PUT /productos/5
exports.update = async function(req, res) {
  const id = req.params.id;
  try {
    await Cuestionario.update(
      req.body,
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'actualizado'
      }
    )  
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};

//DELETE //productos/9
exports.remove = async function(req, res) {
  const id = req.params.id;
  try {
    await Cuestionario.destroy(
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'eliminado'
      }
    )
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};
