const db = require('../models');
const bcrypt = require('bcryptjs');
const Estudiante = db.Estudiante;

exports.list = async function(req, res) {
  try {
    const estudiantes = await Estudiante.findAll(
      {
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        order: [
          'Apellido'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(estudiantes);
  } catch(err) {
    res.status(500).json({error: err});
  }
}
// filtrado de grado
exports.filtergrado = async function(req, res) {
  try {
    const parametrogrado = req.params.grado;
    const filtradogrado = await Estudiante.findAll(
      {
        where: [
          {
            GradoId: parametrogrado
          }
        ],
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(filtradogrado);
  } catch(err) {
    res.status(500).json({error: err});
  }
}
// filtrado de grado y seccion
exports.filtergradoandseccion = async function(req, res) {
  try {
    const parametrogrado = req.params.grado;
    const parametroseccion = req.params.seccion;
    const filtradogradoyseccion = await Estudiante.findAll(
      {
        where: [
          {
            GradoId: parametrogrado,
            Seccion: parametroseccion
          }
        ],
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(filtradogradoyseccion);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.get = async function(req, res) {
  try {
    const id = req.params.id;
    const estudiante = await Estudiante.findOne(
      {
        where: {
          id: id
        },
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(estudiante);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// busquda por correo
exports.searchcel = async function(req, res) {
  try {
    const celular = req.params.celular;
    const usersearchcel = await Estudiante.findOne(
      {
        where: [
          {
            Celular: celular
          }
        ],
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(usersearchcel);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// busquda por celular
exports.searchemail = async function(req, res) {
  try {
    const correo = req.params.correo;
    const usersearchemail = await Estudiante.findOne(
      {
        where: [
          {
            Email: correo
          }
        ],
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(usersearchemail);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// busquda por documento
exports.searchdoc = async function(req, res) {
  try {
    const documento = req.params.documento;
    const usersearchdoc = await Estudiante.findOne(
      {
        where: [
          {
            Documento: documento
          }
        ],
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(usersearchdoc);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// login de estudiantes con su dni Y CONTRA
exports.login = async function(req, res) {
  try {
    const documento = req.params.documento;
    const lacontra = req.params.contra;
    const userlogin = await Estudiante.findOne(
      {
        where: [
          {
            Documento: documento
          }
        ],
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    if (userlogin !== null) {
      const parametro = bcrypt.compareSync(lacontra, userlogin.Password);
      if (parametro) {
        res.json(userlogin);
      } else {
        res.json({msj: 'Contrasenia Incorrecta'});
      }
    } else {
      res.json({msj: 'Documento no existente en nuestra app'});
    }
  } catch(err) {
    res.status(500).json({error: err});
  }
}
      
// creando usuario estudiante encriptando su contra
exports.create = async function(req, res) {
  try{
    const { Nombre, Apellido, Genero, TipoDocumento, Documento, Email, Celular,
    Password, RestablecerContra, Codigo, Seccion, GradoId } = req.body;
    const hashedPassword = await bcrypt.hash(Password, 15);
    const nuevoEstudiante = await Estudiante.create({
      Nombre, Apellido, Genero, TipoDocumento, Documento, Email, Celular,
      Password: hashedPassword, RestablecerContra, Codigo, Seccion, GradoId
    });
    res.json(nuevoEstudiante);
  } catch(err){
      res.status(500).json({error: err});
  }
};

// actualizando todos los datos sin tocas la conta
exports.update = async function(req, res) {
  const id = req.params.id;
  try {
      await Estudiante.update(req.body,{where: {id: id}});
      res.json({ok: 'ok'})
  } catch(error){}
};
// actualizando solo la contra
exports.updatepass = async function(req, res) {
  const id = req.params.id;
  try {
    const { Password } = req.body;
      const hashedPassword = await bcrypt.hash(Password, 15);
      await Estudiante.update({Password: hashedPassword},{where: {id: id}});
      res.json({ok: 'ok'})
  } catch(error){
    res.status(500).json({error: err});
  }
};

//DELETE //Estudiante
exports.remove = async function(req, res) {
  const id = req.params.id;
  try {
      await Estudiante.destroy({where: {id: id} });
      res.json({ok: 'ok'})
        
  } catch(error){
      res.status(500).json({error: err});
  }
};
