const db = require('../models');
const Grado = db.Grado;

exports.list = async function(req, res) {
  try {
    const Grados = await Grado.findAll(
      {
        attributes: [
          'id',
          'Nombre'
        ],
        order: [
          'Nombre'
        ]
      }
    );
    res.json(Grados);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.get = async function(req, res) {
  try {
    const id = req.params.id;
    const grado = await Grado.findOne(
      {
        where: {
          id: id
        },
        attributes: [
          'id',
          'Nombre'
        ]
      }
    );
    res.json(grado);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// POST /productos/
exports.create = async function(req, res) {
  try{
      const nuevoGrado = await Grado.create(req.body);
      res.json(nuevoGrado);
  } catch(err){
      res.status(500).json({error: err});
  }
};

// PUT /productos/5
exports.update = async function(req, res) {
  const id = req.params.id;
  try {
    await Grado.update(
      req.body,
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'actualizado'
      }
    )  
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};

//DELETE //productos/9
exports.remove = async function(req, res) {
  const id = req.params.id;
  try {
    await Grado.destroy(
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'eliminado'
      }
    )
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};
