const db = require('../models');
const Libro = db.Libro;

exports.list = async function(req, res) {
  try {
    const Libros = await Libro.findAll(
      {
        attributes: [
          'id',
          'Titulo',
          'Audio',
          'Video',
          'Imagen',
          'Autor'
        ],
        order: [
          'Titulo'
        ]
      }
    );
    res.json(Libros);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.get = async function(req, res) {
  try {
    const id = req.params.id;
    const libro = await Libro.findOne(
      {
        where: {
          id: id
        },
        attributes: [
          'id',
          'Titulo',
          'Audio',
          'Video',
          'Imagen',
          'Autor'
        ]
      }
    );
    res.json(libro);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// POST /productos/
exports.create = async function(req, res) {
  try{
      const nuevoLibro = await Libro.create(req.body);
      res.json(nuevoLibro);
  } catch(err){
      res.status(500).json({error: err});
  }
};

// PUT /productos/5
exports.update = async function(req, res) {
  const id = req.params.id;
  try {
    await Libro.update(
      req.body,
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'actualizado'
      }
    )  
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};

//DELETE //productos/9
exports.remove = async function(req, res) {
  const id = req.params.id;
  try {
    await Libro.destroy(
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'eliminado'
      }
    )
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};
