const db = require('../models');
const LibroExterno = db.LibroExterno;

exports.list = async function(req, res) {
  try {
    const LibroExternos = await LibroExterno.findAll(
      {
        attributes: [
          'id',
          'Titulo',
          'Autor',
          'Resumen',
          'FechaLectura',
          'GradoySeccion',
          'Validado',
          'EstudianteId'
        ],
        include: [
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento',
              'GradoId'
            ],
            include: [
              {
                model: db.Grado,
                as: 'grado',
                attributes:
                [
                  'id',
                  'Nombre'
                ]
              },
            ]
          }
        ]
      }
    );
    res.json(LibroExternos);
  } catch(err) {
    res.status(500).json({error: err});
  }
}
// // el LibroExterno del estudiante por fechas
// exports.searchestudiante = async function(req, res) {
//   try {
//     const parametro = req.params.estudiante;
//     const fechainicial = new Date(req.params.fechadeinicio);
//     const fechafinal = new Date(req.params.fechadefin);
//     const filterprocesudent = await LibroExterno.findAll(
//       {
//         where: {
//           EstudianteId: parametro,
//           FechaInicio: {
//             [Op.between]:[startOfDay(fechainicial), endOfDay(fechafinal)],
//           },
//           FechaFin: {
//             [Op.between]:[startOfDay(fechainicial), endOfDay(fechafinal)],
//           },
//         },
//         attributes: [
//           'id',
//           'LibroExterno',
//           'Reaccion',
//           'Comentario',
//           'FinalAlternativo',
//           'FechaLectura',
//           'NotaCuestionario',
//           'NumeroIntento',
//           'LibroId',
//           'EstudianteId'
//         ],
//         orderBy: [
//           ['LibroExterno', 'DESC']
//         ],
//         include: [
//           {
//             model: db.Libro,
//             as: 'libro',
//             attributes: [
//               'id',
//               'Titulo',
//               'Audio',
//               'Video',
//               'Autor'
//             ]
//           },
//           {
//             model: db.Estudiante,
//             as: 'estudiante',
//             attributes: [
//               'id',
//               'Nombre',
//               'Apellido',
//               'Genero',
//               'Documento',
//               'GradoId'
//             ],
//             include: [
//               {
//                 model: db.Grado,
//                 as: 'grado',
//                 attributes:
//                 [
//                   'id',
//                   'Nombre'
//                 ]
//               },
//             ]
//           }
//         ]
//       }
//     );
//     res.json(filterprocesudent);
//   } catch(err) {
//     res.status(500).json({error: err});
//   }
// }

exports.getLibroExternoidividual = async function(req, res) {
  try {
    const ellibro = req.params.libro;
    const elestudiante = req.params.estudiante;
    const LibroExternoindividual = await LibroExterno.findOne(
      {
        where: [
          {
            LibroId: ellibro,
            EstudianteId: elestudiante,
          }
        ],
        attributes: [
          'id',
          'Titulo',
          'Autor',
          'Resumen',
          'FechaLectura',
          'GradoySeccion',
          'Validado',
          'EstudianteId'
        ],
        include: [
          {
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Autor'
            ]
          },
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento',
              'GradoId'
            ],
            include: [
              {
                model: db.Grado,
                as: 'grado',
                attributes:
                [
                  'id',
                  'Nombre'
                ]
              },
            ]
          }
        ]
      }
    );
    res.json(LibroExternoindividual);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.get = async function(req, res) {
  try {
    const id = req.params.id;
    const LibroExterno = await LibroExterno.findOne(
      {
        where: {
          id: id
        },
        attributes: [
          'id',
          'Titulo',
          'Autor',
          'Resumen',
          'FechaLectura',
          'GradoySeccion',
          'Validado',
          'EstudianteId'
        ],
        include: [
          {
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Autor'
            ]
          },
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento',
              'GradoId'
            ],
            include: [
              {
                model: db.Grado,
                as: 'grado',
                attributes:
                [
                  'id',
                  'Nombre'
                ]
              },
            ]
          }
        ]
      }
    );
    res.json(LibroExterno);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// POST /productos/
exports.create = async function(req, res) {
  try{
      const nuevoLibroExterno = await LibroExterno.create(req.body);
      res.json(nuevoLibroExterno);
  } catch(err){
      res.status(500).json({error: err});
  }
};

// PUT /productos/5
exports.update = async function(req, res) {
  const id = req.params.id;
  try {
    await LibroExterno.update(
      req.body,
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'actualizado'
      }
    )  
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};

//DELETE //productos/9
exports.remove = async function(req, res) {
  const id = req.params.id;
  try {
    await LibroExterno.destroy(
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'eliminado'
      }
    )
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};
