const db = require('../models');
const Obtencion = db.Obtencion;

exports.list = async function(req, res) {
  try {
    const Obtenciones = await Obtencion.findAll(
      {
        attributes: [
          'id',
          'Cantidad',
          'EstudianteId',
          'TrofeoId'
        ],
        include: [
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento'
            ],
          },
          {
            model: db.Trofeo,
            as: 'trofeo',
            attributes: [
              'id',
              'Imagen',
              'Description'
            ],
          },
        ]
      }
    );
    res.json(Obtenciones);
  } catch(err) {
    res.status(500).json({error: err});
  }
}
// busqueda de los trofeos de los estudiantes
exports.searchestudiante = async function(req, res) {
  try {
    const parametro = req.params.estudiante;
    const busquedatrofeos = await Obtencion.findAll(
      {
        where: {
          EstudianteId: parametro
        },
        attributes: [
          'id',
          'Cantidad',
          'EstudianteId',
          'TrofeoId'
        ],
        include: [
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento'
            ],
          },
          {
            model: db.Trofeo,
            as: 'trofeo',
            attributes: [
              'id',
              'Imagen',
              'Description'
            ],
          },
        ]
      }
    );
    res.json(busquedatrofeos);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.get = async function(req, res) {
  try {
    const id = req.params.id;
    const obtencion = await Obtencion.findOne(
      {
        where: {
          id: id
        },
        attributes: [
          'id',
          'Cantidad',
          'EstudianteId',
          'TrofeoId'
        ],
        include: [
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento'
            ],
          },
          {
            model: db.Trofeo,
            as: 'trofeo',
            attributes: [
              'id',
              'Imagen',
              'Description'
            ],
          },
        ]
      }
    );
    res.json(obtencion);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// POST /productos/
exports.create = async function(req, res) {
  try{
      const nuevoObtencion = await Obtencion.create(req.body);
      res.json(nuevoObtencion);
  } catch(err){
      res.status(500).json({error: err});
  }
};

// PUT /productos/5
exports.update = async function(req, res) {
  const id = req.params.id;
  try {
    await Obtencion.update(
      req.body,
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'actualizado'
      }
    )  
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};

//DELETE //productos/9
exports.remove = async function(req, res) {
  const id = req.params.id;
  try {
    await Obtencion.destroy(
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'eliminado'
      }
    )
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};
