const db = require('../models');
const Parrafo = db.Parrafo;

exports.list = async function(req, res) {
  try {
    const Parrafos = await Parrafo.findAll(
      {
        attributes: [
          'id',
          'Parrafo',
          'Imagen',
          'TipoId',
          'LibroId'
        ],
        include: [
          {
            model: db.Tipo,
            as: 'tipo',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
          {
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Imagen',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(Parrafos);
  } catch(err) {
    res.status(500).json({error: err});
  }
}
// filtrado por libro
exports.searchlibro = async function(req, res) {
  try {
    const parametro = req.params.libro;
    const searchautor = await Parrafo.findAll(
      {
        where: {
          LibroId: parametro
        },
        attributes: [
          'id',
          'Parrafo',
          'Imagen',
          'TipoId',
          'LibroId'
        ],
        include: [
          {
            model: db.Tipo,
            as: 'tipo',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
          {
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Imagen',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(searchautor);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.searchpartes = async function(req, res) {
  try {
    const parametro = req.params.tipo;
    const parametro2 = req.params.libro;
    const searchautor = await Parrafo.findAll(
      {
        where: {
          TipoId: parametro,
          LibroId: parametro2
        },
        attributes: [
          'id',
          'Parrafo',
          'Imagen',
          'TipoId',
          'LibroId'
        ],
        include: [
          {
            model: db.Tipo,
            as: 'tipo',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
          {
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Imagen',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(searchautor);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// filtrado por tipo

exports.get = async function(req, res) {
  try {
    const id = req.params.id;
    const parrafo = await Parrafo.findOne(
      {
        where: {
          id: id
        },
        attributes: [
          'id',
          'Parrafo',
          'Imagen',
          'TipoId',
          'LibroId'
        ],
        include: [
          {
            model: db.Tipo,
            as: 'tipo',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
          {
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Imagen',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(parrafo);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// POST /productos/
exports.create = async function(req, res) {
  try{
      const nuevoParrafo = await Parrafo.create(req.body);
      res.json(nuevoParrafo);
  } catch(err){
      res.status(500).json({error: err});
  }
};

// PUT /productos/5
exports.update = async function(req, res) {
  const id = req.params.id;
  try {
    await Parrafo.update(
      req.body,
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'actualizado'
      }
    )  
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};

//DELETE //productos/9
exports.remove = async function(req, res) {
  const id = req.params.id;
  try {
    await Parrafo.destroy(
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'eliminado'
      }
    )
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};
