const db = require('../models');
const bcrypt = require('bcryptjs');
const Profesor = db.Profesor;

exports.list = async function(req, res) {
  try {
    const profesores = await Profesor.findAll(
      {
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(profesores);
  } catch(err) {
    res.status(500).json({error: err});
  }
}
// filtrado de grado
exports.filtergrado = async function(req, res) {
  try {
    const parametro = req.params.grado;
    const filtradogrado = await Profesor.findAll(
      {
        where: {
          GradoId: parametro
        },
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        order: [
          'Apellido'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(filtradogrado);
  } catch(err) {
    res.status(500).json({error: err});
  }
}
// filtrado de grado y seccion
exports.filtergradoandseccion = async function(req, res) {
  try {
    const parametrogrado = req.params.grado;
    const parametroseccion = req.params.seccion;
    const filtradogradoyseccion = await Profesor.findAll(
      {
        where: {
          GradoId: parametrogrado,
          Seccion: parametroseccion
        },
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        order: [
          'Apellido'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(filtradogradoyseccion);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.get = async function(req, res) {
  try {
    const id = req.params.id;
    const profesor = await Profesor.findOne(
      {
        where: {
          id: id
        },
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(profesor);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// busquda por correo
exports.searchcel = async function(req, res) {
  try {
    const celular = req.params.celular;
    const usersearchcel = await Profesor.findOne(
      {
        where: [
          {
            Celular: celular
          }
        ],
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(usersearchcel);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// busquda por celular
exports.searchemail = async function(req, res) {
  try {
    const correo = req.params.correo;
    const usersearchemail = await Profesor.findOne(
      {
        where: [
          {
            Email: correo
          }
        ],
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(usersearchemail);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// busquda por documento
exports.searchdoc = async function(req, res) {
  try {
    const documento = req.params.documento;
    const usersearchdoc = await Profesor.findOne(
      {
        where: [
          {
            Documento: documento
          }
        ],
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    res.json(usersearchdoc);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// login de docente con su correo Y CONTRA
exports.loginemail = async function(req, res) {
  try {
    const correo = req.params.correo;
    const lacontra = req.params.contra;
    const userlogin = await Profesor.findOne(
      {
        where: [
          {
            Email: correo
          }
        ],
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    console.log(userlogin);
    if (userlogin) {
      const parametro = bcrypt.compareSync(lacontra, userlogin.Password);
      if (parametro) {
        res.json(userlogin);
      } else {
        res.json({msj: 'Contrasenia Incorrecta'});
      }
    } else {
      res.json({msj: 'Correo no existente en nuestra app'});
    }
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// login de docente con su celular Y CONTRA
exports.logicel = async function(req, res) {
  try {
    const celular = req.params.celular;
    const lacontra = req.params.contra;
    const userlogin = await Profesor.findOne(
      {
        where: [
          {
            Celular: celular
          }
        ],
        attributes: [
          'id',
          'Nombre',
          'Apellido',
          'Genero',
          'TipoDocumento',
          'Documento',
          'Email',
          'Celular',
          'Password',
          'RestablecerContra',
          'Codigo',
          'Seccion',
          'GradoId'
        ],
        include: [
          {
            model: db.Grado,
            as: 'grado',
            attributes:
            [
              'id',
              'Nombre'
            ]
          },
        ]
      }
    );
    if (userlogin) {
      const parametro = bcrypt.compareSync(lacontra, userlogin.Password);
      if (parametro) {
        res.json(userlogin);
      } else {
        res.json({msj: 'Contrasenia Incorrecta'});
      }
    } else {
      res.json({msj: 'Celular no existente en nuestra app'});
    }
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// POST /Profesor/
exports.create = async function(req, res) {
  try{
    const { Nombre, Apellido, Genero, TipoDocumento, Documento, Email, Celular,
    Password, RestablecerContra, Codigo, Seccion, GradoId } = req.body;
    const hashedPassword = await bcrypt.hash(Password, 15);
    const nuevoProfesor = await Profesor.create({Nombre, Apellido, Genero, 
      TipoDocumento, Documento, Email, Celular, Password: hashedPassword, 
      RestablecerContra, Codigo, Seccion, GradoId});
    res.json(nuevoProfesor);
  } catch(err){
      res.status(500).json({error: err});
  }
};

// PUT /Profesor/5
exports.update = async function(req, res) {
  const id = req.params.id;
  try {
      await Profesor.update(req.body,{where: {id: id}});
      res.json({ok: 'ok'})
  } catch(error){}
};

// actualizando solo la contra
exports.updatepass = async function(req, res) {
  const id = req.params.id;
  try {
    const { Password } = req.body;
      const hashedPassword = await bcrypt.hash(Password, 15);
      await Profesor.update({Password: hashedPassword},{where: {id: id}});
      res.json({ok: 'ok'})
  } catch(error){
    res.status(500).json({error: err});
  }
};

//DELETE //Profesor
exports.remove = async function(req, res) {
  const id = req.params.id;
  try {
      await Profesor.destroy({where: {id: id} });
      res.json({ok: 'ok'})
        
  } catch(error){
      res.status(500).json({error: err});
  }
};
