const db = require('../models');
const Progreso = db.Progreso;

exports.list = async function(req, res) {
  try {
    const Progresos = await Progreso.findAll(
      {
        attributes: [
          'id',
          'Progreso',
          'Reaccion',
          'Comentario',
          'FinalAlternativo',
          'FechaLectura',
          'NotaCuestionario',
          'NumeroIntento',
          'LibroId',
          'EstudianteId'
        ],
        include: [
          {
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Autor'
            ]
          },
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento',
              'GradoId'
            ],
            include: [
              {
                model: db.Grado,
                as: 'grado',
                attributes:
                [
                  'id',
                  'Nombre'
                ]
              },
            ]
          }
        ]
      }
    );
    res.json(Progresos);
  } catch(err) {
    res.status(500).json({error: err});
  }
}
// el Progreso del estudiante por fechas
exports.searchestudiante = async function(req, res) {
  try {
    const parametro = req.params.estudiante;
    const fechainicial = new Date(req.params.fechadeinicio);
    const fechafinal = new Date(req.params.fechadefin);
    const filterprocesudent = await Progreso.findAll(
      {
        where: {
          EstudianteId: parametro,
          FechaInicio: {
            [Op.between]:[startOfDay(fechainicial), endOfDay(fechafinal)],
          },
          FechaFin: {
            [Op.between]:[startOfDay(fechainicial), endOfDay(fechafinal)],
          },
        },
        attributes: [
          'id',
          'Progreso',
          'Reaccion',
          'Comentario',
          'FinalAlternativo',
          'FechaLectura',
          'NotaCuestionario',
          'NumeroIntento',
          'LibroId',
          'EstudianteId'
        ],
        orderBy: [
          ['Progreso', 'DESC']
        ],
        include: [
          {
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Autor'
            ]
          },
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento',
              'GradoId'
            ],
            include: [
              {
                model: db.Grado,
                as: 'grado',
                attributes:
                [
                  'id',
                  'Nombre'
                ]
              },
            ]
          }
        ]
      }
    );
    res.json(filterprocesudent);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.getprogresoidividual = async function(req, res) {
  try {
    const ellibro = req.params.libro;
    const elestudiante = req.params.estudiante;
    const progresoindividual = await Progreso.findOne(
      {
        where: [
          {
            LibroId: ellibro,
            EstudianteId: elestudiante,
          }
        ],
        attributes: [
          'id',
          'Progreso',
          'Reaccion',
          'Comentario',
          'FinalAlternativo',
          'FechaLectura',
          'NotaCuestionario',
          'NumeroIntento',
          'LibroId',
          'EstudianteId'
        ],
        include: [
          {
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Autor'
            ]
          },
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento',
              'GradoId'
            ],
            include: [
              {
                model: db.Grado,
                as: 'grado',
                attributes:
                [
                  'id',
                  'Nombre'
                ]
              },
            ]
          }
        ]
      }
    );
    res.json(progresoindividual);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.get = async function(req, res) {
  try {
    const id = req.params.id;
    const progreso = await Progreso.findOne(
      {
        where: {
          id: id
        },
        attributes: [
          'id',
          'Progreso',
          'Reaccion',
          'Comentario',
          'FinalAlternativo',
          'FechaLectura',
          'NotaCuestionario',
          'NumeroIntento',
          'LibroId',
          'EstudianteId'
        ],
        include: [
          {
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Autor'
            ]
          },
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento',
              'GradoId'
            ],
            include: [
              {
                model: db.Grado,
                as: 'grado',
                attributes:
                [
                  'id',
                  'Nombre'
                ]
              },
            ]
          }
        ]
      }
    );
    res.json(progreso);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// POST /productos/
exports.create = async function(req, res) {
  try{
      const nuevoProgreso = await Progreso.create(req.body);
      res.json(nuevoProgreso);
  } catch(err){
      res.status(500).json({error: err});
  }
};

// PUT /productos/5
exports.update = async function(req, res) {
  const id = req.params.id;
  try {
    await Progreso.update(
      req.body,
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'actualizado'
      }
    )  
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};

//DELETE //productos/9
exports.remove = async function(req, res) {
  const id = req.params.id;
  try {
    await Progreso.destroy(
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'eliminado'
      }
    )
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};
