const db = require('../models');
const Publicacion = db.Publicacion;

exports.list = async function(req, res) {
  try {
    const Publicaciones = await Publicacion.findAll(
      {
        attributes: [
          'id',
          'Procedencia',
          'FechaRegistro',
          'GradoDestino',
          'LibroId',
          'EstudianteId'
        ],
        include: [
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento'
            ]
          },{
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Imagen',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(Publicaciones);
  } catch(err) {
    res.status(500).json({error: err});
  }
}
// buscar libros registrados por el papa
exports.search = async function(req, res) {
  try {
    const parametro = req.params.autor;
    const searchautor = await Publicacion.findAll(
      {
        where: {
          EstudianteId: parametro
        },
        attributes: [
          'id',
          'Procedencia',
          'FechaRegistro',
          'GradoDestino',
          'LibroId',
          'EstudianteId'
        ],
        include: [
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento'
            ]
          },{
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Imagen',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(searchautor);
  } catch(err) {
    res.status(500).json({error: err});
  }
}
// listado de libros en total
exports.searchproced = async function(req, res) {
  try {
    const parametro = req.params.procedencia;
    const searchprocedencia = await Publicacion.findAll(
      {
        where: {
          Procedencia: parametro
        },
        attributes: [
          'id',
          'Procedencia',
          'FechaRegistro',
          'GradoDestino',
          'LibroId',
          'EstudianteId'
        ],
        include: [
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento'
            ]
          },{
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Imagen',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(searchprocedencia);
  } catch(err) {
    res.status(500).json({error: err});
  }
}
// listado de libros por GradoDestino
exports.searchGradoDestino = async function(req, res) {
  try {
    const parametro = req.params.grado;
    const searchprocedencia = await Publicacion.findAll(
      {
        where: [
          {
          GradoDestino: parametro,
          Procedencia: 'interna'
          }
        ],
        attributes: [
          'id',
          'Procedencia',
          'FechaRegistro',
          'GradoDestino',
          'LibroId',
          'EstudianteId'
        ],
        include: [
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento'
            ]
          },{
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Imagen',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(searchprocedencia);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.searchlibro = async function(req, res) {
  try {
    const parametro = req.params.libro;
    const publicacionbylibro = await Publicacion.findOne(
      {
        where: {
          LibroId: parametro
        },
        attributes: [
          'id',
          'Procedencia',
          'FechaRegistro',
          'GradoDestino',
          'LibroId',
          'EstudianteId'
        ],
        include: [
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento'
            ]
          },{
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Imagen',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(publicacionbylibro);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.get = async function(req, res) {
  try {
    const id = req.params.id;
    const publicacion = await Publicacion.findOne(
      {
        where: {
          id: id
        },
        attributes: [
          'id',
          'Procedencia',
          'FechaRegistro',
          'GradoDestino',
          'LibroId',
          'EstudianteId'
        ],
        include: [
          {
            model: db.Estudiante,
            as: 'estudiante',
            attributes: [
              'id',
              'Nombre',
              'Apellido',
              'Genero',
              'Documento'
            ]
          },{
            model: db.Libro,
            as: 'libro',
            attributes: [
              'id',
              'Titulo',
              'Audio',
              'Video',
              'Imagen',
              'Autor'
            ]
          },
        ]
      }
    );
    res.json(publicacion);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// POST /productos/
exports.create = async function(req, res) {
  try{
      const nuevoPublicacion = await Publicacion.create(req.body);
      res.json(nuevoPublicacion);
  } catch(err){
      res.status(500).json({error: err});
  }
};

// PUT /productos/5
exports.update = async function(req, res) {
  const id = req.params.id;
  try {
    await Publicacion.update(
      req.body,
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'actualizado'
      }
    )  
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};

//DELETE //productos/9
exports.remove = async function(req, res) {
  const id = req.params.id;
  try {
    await Publicacion.destroy(
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'eliminado'
      }
    )
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};
