const db = require('../models');
const { QueryTypes } = require('sequelize');

// conteo de las reacciones por libro interno
exports.reaccionesbylibro = async function(req, res) {
    try {
        const parametro = req.params.libro;
        const sql1 = `
        SELECT COUNT(progreso.id) as conteo, progreso."Reaccion" as reaccion
        FROM public."Progresos" as progreso
        where progreso."LibroId" = ${parametro} and progreso."Progreso" = '100'
        group by reaccion;`;
        const lasreacciones = await db.sequelize.query(
            sql1,
            {
                logging: console.log,
                plain: false,
                raw: false,
                type: QueryTypes.SELECT
            }
        );
        res.json(
            [
                lasreacciones,
                {
                    respuesta: 'Reacciones del libro'
                }
            ]
        );

    } catch (error) {
        res.status(500).json(
            {
                err: error,
            }
        );
    }
}

// listado de quienes reaccionaron
exports.filterlistbylibroandreaccion = async function(req, res) {
    try {
        const parametro = req.params.libro;
        const parametrito = req.params.reaccion;
        const sql1 = `
        SELECT CONCAT_WS(' ', estudiante."Nombre", estudiante."Apellido") as estudiante
        FROM public."Progresos" as progreso inner join public."Estudiantes" as estudiante
        on progreso."EstudianteId" = estudiante.id
        where progreso."LibroId" = ${parametro} and 
        progreso."Progreso" = '100' 
        and progreso."Reaccion" = '${parametrito}'
        order by progreso."FechaLectura" desc;`;
        const listreaccionadores = await db.sequelize.query(
            sql1,
            {
                logging: console.log,
                plain: false,
                raw: false,
                type: QueryTypes.SELECT
            }
        );
        res.json(
            [
                listreaccionadores,
                {
                    respuesta: 'Listado de los que reaccionaron'
                }
            ]
        );

    } catch (error) {
        res.status(500).json(
            {
                err: error,
            }
        );
    }
}

// listado de estadisticas individuales de los estudiantes
// aniadir rango de fechas
exports.individualstatistics = async function(req, res) {
    try {
        const parametro = req.params.estudiante;
        const start = req.params.start;
        const end = req.params.end;
        // videos vistos
        const sql1 = `
        SELECT COUNT(pro.id) as videos_vistos
        FROM public."Progresos" as pro inner join public."Libros" as li	on pro."LibroId" = li.id
        where pro."Progreso" > 0 and pro."EstudianteId" = ${parametro} and li."Video" != '' and
        pro."FechaLectura"::date between '${start}'::DATE and '${end}'::DATE;`;
        // audios escuchados
        const sql2 = `
        SELECT COUNT(pro.id) as audios_escuchados
        FROM public."Progresos" as pro inner join public."Libros" as li	on pro."LibroId" = li.id
        where pro."Progreso" > 0 and pro."EstudianteId" = ${parametro} and li."Audio" != '' and
        pro."FechaLectura"::date between '${start}'::DATE and '${end}'::DATE;`;
        // lecturas 
        const sql3 = `
        SELECT COUNT(pro.id) as libros_leidos,
        ROUND(AVG(pro."Progreso"),2) as progreso,
        ROUND(AVG(pro."NotaCuestionario"),2) as nota,
        ROUND(AVG(pro."NumeroIntento"),2) as intentos
        FROM public."Progresos" as pro inner join public."Libros" as li	on pro."LibroId" = li.id
        where pro."Progreso" > 0 and pro."EstudianteId" = ${parametro} and
        pro."FechaLectura"::date between '${start}'::DATE and '${end}'::DATE;`;
        const cantidadvideosvistos = await db.sequelize.query(
            sql1,
            {
                logging: console.log,
                plain: false,
                raw: false,
                type: QueryTypes.SELECT
            }
        );
        const cantidadaudiosescuchados = await db.sequelize.query(
            sql2,
            {
                logging: console.log,
                plain: false,
                raw: false,
                type: QueryTypes.SELECT
            }
        );
        const cantidadlibrosleidos = await db.sequelize.query(
            sql3,
            {
                logging: console.log,
                plain: false,
                raw: false,
                type: QueryTypes.SELECT
            }
        );
        res.json(
            [
                cantidadvideosvistos,
                cantidadaudiosescuchados,
                cantidadlibrosleidos,
                {
                    respuesta: 'Contador de Estadisticas Individuales del Estudiante'
                }
            ]
        );

    } catch (error) {
        res.status(500).json(
            {
                err: error,
            }
        );
    }
}

// listado de estadisticas individuales de los estudiantes de manera mas detallada
exports.individualstatisticsdetalladas = async function(req, res) {
    try {
        const parametro = req.params.estudiante;
        const start = req.params.start;
        const end = req.params.end;
        const sql1 = `
        SELECT li.id as Codigo, li."Titulo" as Titulo, li."Imagen" as Imagen, li."Autor" as Autor
        FROM public."Progresos" as pro inner join public."Libros" as li	on pro."LibroId" = li.id
        where pro."Progreso" > 0 and pro."EstudianteId" = ${parametro}	and li."Video" != '' and
        pro."FechaLectura"::date between '${start}'::DATE and '${end}'::DATE;`;
        // audios escuchados
        const sql2 = `
        SELECT li.id as Codigo, li."Titulo" as Titulo, li."Imagen" as Imagen, li."Autor" as Autor
        FROM public."Progresos" as pro inner join public."Libros" as li	on pro."LibroId" = li.id
        where pro."Progreso" > 0 and pro."EstudianteId" = ${parametro}	and li."Audio" != '' and
        pro."FechaLectura"::date between '${start}'::DATE and '${end}'::DATE;`;
        // lecturas 
        const sql3 = `
        SELECT li.id as Codigo, li."Titulo" as Titulo, li."Imagen" as Imagen, li."Autor" as Autor
        FROM public."Progresos" as pro inner join public."Libros" as li	on pro."LibroId" = li.id
        where pro."Progreso" > 0 and pro."EstudianteId" = ${parametro} and
        pro."FechaLectura"::date between '${start}'::DATE and '${end}'::DATE;`;
        const videosvistos = await db.sequelize.query(
            sql1,
            {
                logging: console.log,
                plain: false,
                raw: false,
                type: QueryTypes.SELECT
            }
        );
        const audiosescuchados = await db.sequelize.query(
            sql2,
            {
                logging: console.log,
                plain: false,
                raw: false,
                type: QueryTypes.SELECT
            }
        );
        const librosleidos = await db.sequelize.query(
            sql3,
            {
                logging: console.log,
                plain: false,
                raw: false,
                type: QueryTypes.SELECT
            }
        );
        res.json(
            [
                videosvistos,
                audiosescuchados,
                librosleidos,
                {
                    respuesta: 'Detalles de los libros leidos'
                }
            ]
        );

    } catch (error) {
        res.status(500).json(
            {
                err: error,
            }
        );
    }
}

// estadisticas globales de todo los estudiantes

// estadisticas por salon
exports.estadisticasporsalonyseccion = async function(req, res) {
    try {
        const grado = req.params.grado;
        const seccion = req.params.seccion;
        const start = req.params.start;
        const end = req.params.end;
        const sql1 = `
        SELECT ROUND(AVG(pro."Progreso"),2) as progreso,
        ROUND(AVG(pro."NotaCuestionario"),2) as nota,
        ROUND(AVG(pro."NumeroIntento"),2) as intentos,
        Count(pro.id) as lecturas
        FROM public."Progresos" as pro
        inner join public."Estudiantes" as est
        on pro."EstudianteId" = est.id
        where est."GradoId" = ${grado} and est."Seccion" = '${seccion}' and
        pro."FechaLectura"::date between '${start}'::date and '${end}'::date;`;
        const lasestadisticas = await db.sequelize.query(
            sql1,
            {
                logging: console.log,
                plain: false,
                raw: false,
                type: QueryTypes.SELECT
            }
        );
        res.json(
            [
                lasestadisticas,
                {
                    respuesta: 'Estadisticas por grado y seccion entre fechas'
                }
            ]
        );

    } catch (error) {
        res.status(500).json(
            {
                err: error,
            }
        );
    }
}


// categorizacion de lectura por grado




// // tres reportes de las reservas de la cancha
// // cliente que mas aporta segun rango de fechas
// exports.reportconsolidado = async function(req, res) {
//     try {
//         const fechaInicio = req.params.fechastart;
//         const fechaFin = req.params.fechaend;
//         const sql1 = `
//         SELECT 
//         c."Appointment" as fecha,
//         c."Condition" as Estado,
//         c."Type" as tipo,
//         CONCAT_WS(' ', ad."Name", ad."LastName") as trabajador,
//         CONCAT_WS(' ', cli."Name", cli."LastName") as cliente,
//         CONCAT_WS(' ', doc."Name", doc."LastName") as doctor,
//         es."Name" as especialidad,
//         ho."Day" as dia,
//         ho."Cupo" as cupo,
//         h."Turn" as turno,
//         CONCAT_WS(' - ', h."Start", h."End") as lapzo
//         FROM public."Cita" as c
//         inner join public."Clientes" as cli on c."ClienteId" = cli.id
//         inner join public."Admins" as ad on c."AdminId" = ad.id
//         inner join public."Horarios" as ho on c."HorarioId" = ho.id
//         inner join public."Horas" as h on ho."HoraId" = h.id
//         inner join public."Especialista" as esp on ho."EspecialistaId" = esp.id
//         inner join public."Doctors" as doc on esp."DoctorId" = doc.id
//         inner join public."Especialidads" as es on esp."EspecialidadId" = es.id
//         where c."Appointment" between '${fechaInicio}'::DATE and '${fechaFin}'::DATE
//         and c."Condition" = 'atendido'
//         order by c."Appointment";`;
//         const sql2 = `
//         SELECT 
//         c."Appointment" as fecha,
//         c."Condition" as Estado,
//         c."Type" as tipo,
//         CONCAT_WS(' ', ad."Name", ad."LastName") as trabajador,
//         CONCAT_WS(' ', cli."Name", cli."LastName") as cliente,
//         CONCAT_WS(' ', doc."Name", doc."LastName") as doctor,
//         es."Name" as especialidad,
//         ho."Day" as dia,
//         ho."Cupo" as cupo,
//         h."Turn" as turno,
//         CONCAT_WS(' - ', h."Start", h."End") as lapzo
//         FROM public."Cita" as c
//         inner join public."Clientes" as cli on c."ClienteId" = cli.id
//         inner join public."Admins" as ad on c."AdminId" = ad.id
//         inner join public."Horarios" as ho on c."HorarioId" = ho.id
//         inner join public."Horas" as h on ho."HoraId" = h.id
//         inner join public."Especialista" as esp on ho."EspecialistaId" = esp.id
//         inner join public."Doctors" as doc on esp."DoctorId" = doc.id
//         inner join public."Especialidads" as es on esp."EspecialidadId" = es.id
//         where c."Appointment" between '${fechaInicio}'::DATE and '${fechaFin}'::DATE
//         and c."Condition" = 'no vino'
//         order by c."Appointment";`;
//         const sql3 = `
//         SELECT 
//         c."Appointment" as fecha,
//         c."Condition" as Estado,
//         c."Type" as tipo,
//         CONCAT_WS(' ', ad."Name", ad."LastName") as trabajador,
//         CONCAT_WS(' ', cli."Name", cli."LastName") as cliente,
//         CONCAT_WS(' ', doc."Name", doc."LastName") as doctor,
//         es."Name" as especialidad,
//         ho."Day" as dia,
//         h."Turn" as turno,
//         CONCAT_WS(' - ', h."Start", h."End") as lapzo
//         FROM public."Cita" as c
//         inner join public."Clientes" as cli on c."ClienteId" = cli.id
//         inner join public."Admins" as ad on c."AdminId" = ad.id
//         inner join public."Horarios" as ho on c."HorarioId" = ho.id
//         inner join public."Horas" as h on ho."HoraId" = h.id
//         inner join public."Especialista" as esp on ho."EspecialistaId" = esp.id
//         inner join public."Doctors" as doc on esp."DoctorId" = doc.id
//         inner join public."Especialidads" as es on esp."EspecialidadId" = es.id
//         where c."updatedAt" between '${fechaInicio}'::DATE and '${fechaFin}'::DATE
//         and c."Condition" = 'reservado'
//         order by c."Appointment";`;
//         const sql4 = `
//         SELECT 
//         c."Appointment" as fecha,
//         c."Condition" as Estado,
//         c."Type" as tipo,
//         CONCAT_WS(' ', ad."Name", ad."LastName") as trabajador,
//         CONCAT_WS(' ', cli."Name", cli."LastName") as cliente,
//         CONCAT_WS(' ', doc."Name", doc."LastName") as doctor,
//         es."Name" as especialidad,
//         ho."Day" as dia,
//         h."Turn" as turno,
//         CONCAT_WS(' - ', h."Start", h."End") as lapzo
//         FROM public."Cita" as c
//         inner join public."Clientes" as cli on c."ClienteId" = cli.id
//         inner join public."Admins" as ad on c."AdminId" = ad.id
//         inner join public."Horarios" as ho on c."HorarioId" = ho.id
//         inner join public."Horas" as h on ho."HoraId" = h.id
//         inner join public."Especialista" as esp on ho."EspecialistaId" = esp.id
//         inner join public."Doctors" as doc on esp."DoctorId" = doc.id
//         inner join public."Especialidads" as es on esp."EspecialidadId" = es.id
//         where c."updatedAt"::date between '${fechaInicio}'::DATE and '${fechaFin}'::DATE
//         and c."Condition" = 'postergado'
//         order by c."Appointment";`;
//         const atenciones = await db.sequelize.query(
//             sql1,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         const novino = await db.sequelize.query(
//             sql2,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         const reservaciones = await db.sequelize.query(
//             sql3,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         const postergaciones = await db.sequelize.query(
//             sql4,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         res.json(
//             [
//                 atenciones,
//                 novino,
//                 reservaciones,
//                 postergaciones,
//                 {
//                     respuesta: 'Reporte Generado'
//                 }
//             ]
//         );
//     } catch (error) {
//         res.status(500).json(
//             {
//                 err: error,
//             }
//         );
//     }
// }

// exports.reportflujodecaja = async function(req, res) {
//     try {
//         const fecha = req.params.fecha;
//         const sql1 = `
//         SELECT CONCAT(d."Name", ' ', d."LastName") AS "doctor", SUM(cast(c."Amount" as float)) as monto
//         FROM public."Cita" as c 
//         inner join public."Horarios" as h
//         on c."HorarioId" = h.id
//         inner join public."Especialista" as e
//         on h."EspecialistaId" = e.id
//         inner join public."Doctors" as d
//         on e."DoctorId" = d.id
//         where c."updatedAt"::date = '${fecha}'::date
//         group by "doctor";`;
//         const reporte = await db.sequelize.query(
//             sql1,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         res.json(
//             [
//                 reporte,
//                 {
//                     respuesta: 'Reporte Generado'
//                 }
//             ]
//         );
//     } catch (error) {
//         res.status(500).json(
//             {
//                 err: error,
//             }
//         );
//     }
// }

// exports.reportflujodecajaentrefechas = async function(req, res) {
//     try {
//         const fechaInicio = req.params.start;
//         const fechaFin = req.params.end;
//         const sql1 = `
//         SELECT CONCAT(d."Name", ' ', d."LastName") AS "doctor", SUM(cast(c."Amount" as float)) as monto
//         FROM public."Cita" as c 
//         inner join public."Horarios" as h
//         on c."HorarioId" = h.id
//         inner join public."Especialista" as e
//         on h."EspecialistaId" = e.id
//         inner join public."Doctors" as d
//         on e."DoctorId" = d.id
//         where c."updatedAt"::date between '${fechaInicio}'::date and '${fechaFin}'::date
//         group by "doctor";`;
//         const reporteflujo = await db.sequelize.query(
//             sql1,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         res.json(
//             [
//                 reporteflujo,
//                 {
//                     respuesta: 'Reporte Generado'
//                 }
//             ]
//         );
//     } catch (error) {
//         res.status(500).json(
//             {
//                 err: error,
//             }
//         );
//     }
// }

// // operaciones hechas por cada admin
// exports.admin = async function(req, res) {
//     try {
//         const fechaInicio = req.params.fechastart;
//         const fechaFin = req.params.fechaend;
//         const sql = `
//         SELECT ad."Fullname" AS Administrador, COUNT(res.id) AS Cantidad
//         FROM public."Reservas" as res
//         inner join public."Admins" AS ad on res."AdminId" = ad.id 
//         WHERE res."FechaReserva" >=  '${fechaInicio}'   AND res."FechaReserva" < '${fechaFin}'
//         GROUP BY ad."Fullname"
//         ORDER BY  Cantidad DESC
//         LIMIT 5;`;
//         const incomeadmin = await db.sequelize.query(
//             sql,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         res.json(incomeadmin);
//     } catch (error) {
//         res.status(500).json(error);
//     }
// }


// // catidad por estado en rango de fechas
// exports.estado = async function(req, res) {
//     try {
//         const fechaInicio = req.params.fechastart;
//         const fechaFin = req.params.fechaend;
//         const sql = `
//         SELECT res."Estado" AS estados, COUNT(res.id) AS Cantidad
//         FROM public."Reservas" as res
//         WHERE res."FechaReserva" >=  '${fechaInicio}'   AND res."FechaReserva" < '${fechaFin}'
//         GROUP BY res."Estado"
//         ORDER BY  Cantidad DESC;`;
//         const statecontrol = await db.sequelize.query(
//             sql,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         res.json(statecontrol);
//     } catch (error) {
//         res.status(500).json(error);
//     }
// }

// // las reservas realizadas en rango de fechas
// exports.estadodetallado = async function(req, res) {
//     try {
//         const fechaInicio = req.params.fechastart;
//         const fechaFin = req.params.fechaend;
//         const sql = `
//         SELECT res.id as codigo,cli."Fullname" as cliente,res."FechaReserva" as fecha, res."Estado" as estado, res."Pago" as pago
//         FROM public."Reservas" as res
//         inner join public."Clientes" AS cli on res."ClienteId" = cli.id
//         WHERE res."FechaReserva" >=  '${fechaInicio}'   AND res."FechaReserva" < '${fechaFin}';`;
//         const statecontroldetail = await db.sequelize.query(
//             sql,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         res.json(statecontroldetail);
//     } catch (error) {
//         res.status(500).json(error);
//     }
// }

// exports.escritorio = async function(req, res) {
//     try {
//         const lafecha = req.params.fechita;
//         const sql = `
//         SELECT res.id as codigo,cli."Fullname" as cliente,res."FechaReserva" as fecha, res."Estado" as estado, res."Pago" as pago
//         FROM public."Reservas" as res
//         inner join public."Clientes" AS cli on res."ClienteId" = cli.id
//         WHERE res."FechaReserva" =  '${lafecha}';`;
//         const reservasdia = await db.sequelize.query(
//             sql,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         res.json(reservasdia);
//     } catch (error) {
//         res.status(500).json(error);
//     }
// }

// // dos reportes de reserva de local
// // las reservas del local con su estado en rango de fechas
// exports.localestado = async function(req, res) {
//     try {
//         const fechaInicio = req.params.fechastart;
//         const fechaFin = req.params.fechaend;
//         const sql = `
//         SELECT res."FechaReservaLocal" as fechita, res."Estado", cli."Fullname" as cliente, res."Pago", res."Total"
//         FROM public."ReservaLocals" as res
//         inner join public."Clientes" as cli on res."ClienteId" = cli.id
//         inner join public."Admins" AS ad on res."AdminId" = ad.id 
//         where res."FechaReservaLocal" between '${fechaInicio}'::DATE and '${fechaFin}'::DATE
//         order by fechita;`;
//         const checkbasic = await db.sequelize.query(
//             sql,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         res.json(checkbasic);
//     } catch (error) {
//         res.status(500).json(error);
//     }
// }

// // el cliente que mas aporta con sus reservas de local
// exports.localcustomer = async function(req, res) {
//     try {
//         const fechaInicio = req.params.fechastart;
//         const fechaFin = req.params.fechaend;
//         const sql = `
//         SELECT  cli."Fullname" AS cliente,COUNT(cli.id) AS atenciones, SUM(res."Pago") AS Ingresos
//         FROM public."ReservaLocals" as res
//         inner join public."Clientes" AS cli on res."ClienteId" = cli.id
//         where res."FechaReservaLocal" between '${fechaInicio}'::DATE and '${fechaFin}'::DATE
//         GROUP BY cli."Fullname"
//         ORDER BY  Ingresos DESC
//         LIMIT 10;`;
//         const incomecustomerlocal = await db.sequelize.query(
//             sql,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         res.json(incomecustomerlocal);
//     } catch (error) {
//         res.status(500).json(error);
//     }
// }

// // reporte para el arqueo de caja con doble consulta
// exports.arqueocaja = async function(req, res) {
//     try {
//         const fechaInicio = req.params.fechastart;
//         const fechaFin = req.params.fechaend;
//         const sql1 = `
//         SELECT  cli."Fullname" as cliente,COUNT(cli.id) as atenciones, SUM(res."Pago") as Ingresos
//         FROM public."Reservas" as res
//         inner join public."Clientes" AS cli on res."ClienteId" = cli.id
//         where res."FechaReserva" between '${fechaInicio}'::DATE and '${fechaFin}'::DATE
//         GROUP BY cli."Fullname"
//         ORDER BY  Ingresos DESC;`;
//         const sql2 = `
//         SELECT igv."FechaReservacion" as fecha, igv."Pago" as egresos, igv."ReservaId" as reserva
//         FROM public."Eligvs" as igv
//         where igv."FechaReservacion" between '${fechaInicio}'::DATE and '${fechaFin}'::DATE;`;
//         const ingresos = await db.sequelize.query(
//             sql1,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         const egresos = await db.sequelize.query(
//             sql2,
//             {
//                 logging: console.log,
//                 plain: false,
//                 raw: false,
//                 type: QueryTypes.SELECT
//             }
//         );
//         res.json([ingresos,egresos,{respuesta: 'ok'}]);
//     } catch (error) {
//         res.status(500).json(error);
//     }
// }