const db = require('../models');
const Resolucion = db.Resolucion;

exports.list = async function(req, res) {
  try {
    const Resolucions = await Resolucion.findAll(
      {
        attributes: [
          'id',
          'Pregunta',
          'RespuestaEscogida',
          'NumeroIntento',
          'Correcto',
          'ProgresoId'
        ]
      }
    );
    res.json(Resolucions);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.filterbyprogress = async function(req, res) {
  try {
    const parametro = req.params.progreso;
    const Resolucions = await Resolucion.findAll(
      {
        where: {
          ProgresoId: parametro
        },
        attributes: [
          'id',
          'Pregunta',
          'RespuestaEscogida',
          'NumeroIntento',
          'Correcto',
          'ProgresoId'
        ]
      }
    );
    res.json(Resolucions);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.filterbyprogressandnitento = async function(req, res) {
  try {
    const parametro = req.params.progreso;
    const parametrito = req.params.intento;
    const Resolucions = await Resolucion.findAll(
      {
        where: [
          {
            ProgresoId: parametro,
            NumeroIntento: parametrito
          }
        ],
        attributes: [
          'id',
          'Pregunta',
          'RespuestaEscogida',
          'NumeroIntento',
          'Correcto',
          'ProgresoId'
        ]
      }
    );
    res.json(Resolucions);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.get = async function(req, res) {
  try {
    const id = req.params.id;
    const Resolucion = await Resolucion.findOne(
      {
        where: {
          id: id
        },
        attributes: [
          'id',
          'Pregunta',
          'RespuestaEscogida',
          'NumeroIntento',
          'Correcto',
          'ProgresoId'
        ]
      }
    );
    res.json(Resolucion);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// POST /productos/
exports.create = async function(req, res) {
  try{
      const nuevoResolucion = await Resolucion.create(req.body);
      res.json(nuevoResolucion);
  } catch(err){
      res.status(500).json({error: err});
  }
};

// PUT /productos/5
exports.update = async function(req, res) {
  const id = req.params.id;
  try {
    await Resolucion.update(
      req.body,
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'actualizado'
      }
    )  
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};

//DELETE //productos/9
exports.remove = async function(req, res) {
  const id = req.params.id;
  try {
    await Resolucion.destroy(
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'eliminado'
      }
    )
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};
