const db = require('../models');
const Trofeo = db.Trofeo;

exports.list = async function(req, res) {
  try {
    const Trofeos = await Trofeo.findAll(
      {
        attributes: [
          'id',
          'Imagen',
          'Description'
        ]
      }
    );
    res.json(Trofeos);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

exports.get = async function(req, res) {
  try {
    const id = req.params.id;
    const trofeo = await Trofeo.findOne(
      {
        where: {
          id: id
        },
        attributes: [
          'id',
          'Imagen',
          'Description'
        ]
      }
    );
    res.json(trofeo);
  } catch(err) {
    res.status(500).json({error: err});
  }
}

// POST /productos/
exports.create = async function(req, res) {
  try{
      const nuevoTrofeo = await Trofeo.create(req.body);
      res.json(nuevoTrofeo);
  } catch(err){
      res.status(500).json({error: err});
  }
};

// PUT /productos/5
exports.update = async function(req, res) {
  const id = req.params.id;
  try {
    await Trofeo.update(
      req.body,
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'actualizado'
      }
    )  
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};

//DELETE //productos/9
exports.remove = async function(req, res) {
  const id = req.params.id;
  try {
    await Trofeo.destroy(
      {
        where: {
          id: id
        }
      }
    );
    res.json(
      {
        ok: 'eliminado'
      }
    )
  } catch(error){
    res.status(500).json(
      {
        error: err
      }
    );
  }
};
