'use strict';
module.exports = (sequelize, DataTypes) => {
  const Cuestionario = sequelize.define(
    'Cuestionario',
    {
      Pregunta: {
        type: DataTypes.TEXT,
        allowNull: false
      },
      RespuestaCorrecta: {
        type: DataTypes.TEXT,
        allowNull: false
      },
      RespuestaIncorrecta1: {
        type: DataTypes.TEXT,
        allowNull: false
      },
      RespuestaIncorrecta2: {
        type: DataTypes.TEXT,
        allowNull: false
      }
    }, 
    {
      schema: 'public'
    }
  );

  Cuestionario.associate = function(models) {
    Cuestionario.belongsTo(
      models.Libro,
      {
        foreignKey: 'LibroId',
        as: 'libro' 
      }
    );
  };

  return Cuestionario;
};