'use strict';
module.exports = (sequelize, DataTypes) => {
  const Libro = sequelize.define(
    'Libro',
    {
      Titulo: {
        type: DataTypes.STRING(250),
        allowNull: false,
      },
      Audio: DataTypes.TEXT,
      Video: DataTypes.TEXT,
      Imagen: DataTypes.TEXT,
      Autor: {
        type: DataTypes.STRING(250),
        allowNull: false,
      }
    },
    {
      schema: 'public'
    }
  );

  Libro.associate = function(models) {
    Libro.hasMany(
      models.Publicacion,
      {
        foreignKey: 'LibroId'
      }
    );
    Libro.hasMany(
      models.Progreso,
      {
        foreignKey: 'LibroId'
      }
    );
    Libro.hasMany(
      models.Parrafo,
      {
        foreignKey: 'LibroId'
      }
    );
    Libro.hasMany(
      models.Cuestionario,
      {
        foreignKey: 'LibroId'
      }
    );
  };

  return Libro;
};