'use strict';
module.exports = (sequelize, DataTypes) => {
  const LibroExterno = sequelize.define(
    'LibroExterno',
    {
      Titulo: {
        type: DataTypes.TEXT,
        allowNull: false,
      },
      Autor: {
        type: DataTypes.TEXT,
        allowNull: false,
      },
      Resumen: {
        type: DataTypes.TEXT,
        allowNull: false,
      },
      FechaLectura: {
        type: DataTypes.DATE,
        allowNull: false,
      },
      GradoySeccion: {
        type: DataTypes.STRING(20),
        allowNull: false,
      },
      Validado: {
        type: DataTypes.STRING(10),
        allowNull: false,
      },
    },
    {
      schema: 'public'
    }
  );

  LibroExterno.associate = function(models) {
    LibroExterno.belongsTo(
      models.Estudiante,
      {
        foreignKey: 'EstudianteId',
        as: 'estudiante' 
      }
    );
  };
  
  return LibroExterno;
};