'use strict';
module.exports = (sequelize, DataTypes) => {
  const Parrafo = sequelize.define(
    'Parrafo',
    {
      Parrafo: DataTypes.TEXT,
      Imagen: DataTypes.TEXT
    }, 
    {
      schema: 'public'
    }
  );

  Parrafo.associate = function(models) {
    Parrafo.belongsTo(
      models.Tipo,
      {
        foreignKey: 'TipoId',
        as: 'tipo' 
      }
    );
    Parrafo.belongsTo(
      models.Libro,
      {
        foreignKey: 'LibroId',
        as: 'libro' 
      }
    );
  };

  return Parrafo;
};