'use strict';
module.exports = (sequelize, DataTypes) => {
  const Profesor = sequelize.define(
    'Profesor',
    {
      Nombre: {
        type: DataTypes.STRING(100),
        allowNull: false
      },
      Apellido:  {
        type: DataTypes.STRING(100),
        allowNull: false
      },
      Genero:  {
        type: DataTypes.STRING(15),
        allowNull: false
      },
      TipoDocumento:  {
        type: DataTypes.STRING(15),
        allowNull: false
      },
      Documento: {
        type: DataTypes.STRING(20),
        unique: true,
        allowNull: false
      },
      Email: {
        type: DataTypes.STRING(100),
        unique: true,
        allowNull: false
      },
      Celular: {
        type: DataTypes.STRING(50),
        unique: true,
        allowNull: false
      },
      Password: {
        type: DataTypes.TEXT,
        allowNull: false
      },
      RestablecerContra: {
        type: DataTypes.STRING(15),
        allowNull: false
      },
      Codigo: {
        type: DataTypes.STRING(20),
        allowNull: false
      },
      Seccion: {
        type: DataTypes.STRING(2),
        allowNull: false
      }
    }, 
    {
      schema: 'public'
    }
  );

  Profesor.associate = function(models) {
    Profesor.belongsTo(
      models.Grado,
      {
        foreignKey: 'GradoId',
        as: 'grado' 
      }
    );
    Profesor.hasMany(
      models.Publicacion,
      {
        foreignKey: 'EstudianteId'
      }
    );
  };

  return Profesor;
};