'use strict';
module.exports = (sequelize, DataTypes) => {
  const Progreso = sequelize.define(
    'Progreso',
    {
      Progreso: {
        type: DataTypes.INTEGER,
        allowNull: false
      },
      Reaccion: {
        type: DataTypes.STRING(25),
        allowNull: false,
      },
      Comentario: {
        type: DataTypes.TEXT,
        allowNull: false,
      },
      FinalAlternativo: {
        type: DataTypes.TEXT,
        allowNull: false,
      },
      FechaLectura: {
        type: DataTypes.DATE,
        allowNull: false,
      },
      NotaCuestionario: {
        type: DataTypes.INTEGER,
        allowNull: false,
      },
      NumeroIntento: {
        type: DataTypes.INTEGER,
        allowNull: false,
      },
    },
    {
      schema: 'public'
    }
  );

  Progreso.associate = function(models) {
    Progreso.belongsTo(
      models.Libro,
      {
        foreignKey: 'LibroId',
        as: 'libro' 
      }
    );
    Progreso.belongsTo(
      models.Estudiante,
      {
        foreignKey: 'EstudianteId',
        as: 'estudiante' 
      }
    );
    Progreso.hasMany(
      models.Resolucion,
      {
        foreignKey: 'ProgresoId'
      }
    );
  };
  
  return Progreso;
};