'use strict';
module.exports = (sequelize, DataTypes) => {
  const Publicacion = sequelize.define(
    'Publicacion',
    {
      Procedencia: {
        type: DataTypes.STRING(50),
        allowNull: false,
      },
      FechaRegistro: {
        type: DataTypes.DATE,
        allowNull: false
      },
      GradoDestino: {
        type: DataTypes.STRING(10),
        allowNull: false,
      },
    },
    {
      schema: 'public'
    }
  );

  Publicacion.associate = function(models) {
    Publicacion.belongsTo(
      models.Libro,
      {
        foreignKey: 'LibroId',
        as: 'libro' 
      }
    );
    Publicacion.belongsTo(
      models.Profesor,
      {
        foreignKey: 'ProfesorId',
        as: 'profesor' 
      }
    );
  };
  
  return Publicacion;
};