'use strict';
module.exports = (sequelize, DataTypes) => {
  const Resolucion = sequelize.define(
    'Resolucion',
    {
      Pregunta: DataTypes.TEXT,
      RespuestaEscogida: DataTypes.TEXT,
      NumeroIntento: DataTypes.STRING(2),
      Correcto: DataTypes.STRING(10)
    }, 
    {
      schema: 'public'
    }
  );

  Resolucion.associate = function(models) {
    Resolucion.belongsTo(
      models.Progreso,
      {
        foreignKey: 'ProgresoId',
        as: 'progreso' 
      }
    );
  };

  return Resolucion;
};