const express = require('express');
const router = express.Router();
const estudianteCtrl = require(
    '../controllers/estudiante.controller'
);

router.get(
    '/',
    estudianteCtrl.list
);
router.get(
    '/:id',
    estudianteCtrl.get
);
router.post(
    '/create',
    estudianteCtrl.create
);
router.put(
    '/update/:id',
    estudianteCtrl.update
);
router.delete(
    '/:id',
    estudianteCtrl.remove
);
//para busqueda por celular
router.get(
    '/searchcel/:celular',
    estudianteCtrl.searchcel
);
//para busqueda por correo
router.get(
    '/searchemail/:correo',
    estudianteCtrl.searchemail
);
//para busqueda por documento
router.get(
    '/searchdoc/:documento',
    estudianteCtrl.searchdoc
);
//para login con solo dni y una contra
router.get(
    '/login/:documento/:contra',
    estudianteCtrl.login
);
//filtro por grado
router.get(
    '/filter/grado/:grado',
    estudianteCtrl.filtergrado
);
//filtro por grado y seccion
router.get(
    '/filter/gradoandseccion/:grado/:seccion',
    estudianteCtrl.filtergradoandseccion
);
// solo actualizar la contra
router.put(
    '/updatepass/:id',
    estudianteCtrl.updatepass
);

module.exports = router;
