const express = require('express');
const router = express.Router();
const libroCtrl = require(
    '../controllers/libro.controller'
);

router.get(
    '/',
    libroCtrl.list
);
router.get(
    '/:id',
    libroCtrl.get
);
router.post(
    '/create',
    libroCtrl.create
);
router.put(
    '/update/:id',
    libroCtrl.update
);
router.delete(
    '/:id',
    libroCtrl.remove
);

module.exports = router;
