const express = require('express');
const router = express.Router();
const libroexternoCtrl = require(
    '../controllers/libroexterno.controller'
);

router.get(
    '/',
    libroexternoCtrl.list
);
router.get(
    '/:id',
    libroexternoCtrl.get
);
router.post(
    '/create',
    libroexternoCtrl.create
);
router.delete(
    '/:id',
    libroexternoCtrl.remove
);
router.put(
    '/update/:id',
    libroexternoCtrl.update
);

router.get(
    '/filter/libroexternoidividual/:estudiante',
    libroexternoCtrl.getLibroExternoidividual
);

module.exports = router;
