const express = require('express');
const router = express.Router();
const parrafoCtrl = require(
    '../controllers/parrafo.controller'
);

router.get(
    '/',
    parrafoCtrl.list
);
router.get(
    '/:id',
    parrafoCtrl.get
);
router.post(
    '/create',
    parrafoCtrl.create
);
router.delete(
    '/:id',
    parrafoCtrl.remove
);
router.put(
    '/update/:id',
    parrafoCtrl.update
);
// filtrar por libro
router.get(
    '/filter/libro/:libro',
    parrafoCtrl.searchlibro
);
// filtrar por tipo
router.get(
    '/filter/partes/:tipo/:libro',
    parrafoCtrl.searchpartes
);

module.exports = router;
