const express = require('express');
const router = express.Router();
const profesorCtrl = require(
    '../controllers/profesor.controller'
);

router.get(
    '/',
    profesorCtrl.list
);
router.get(
    '/:id',
    profesorCtrl.get
);
router.post(
    '/create',
    profesorCtrl.create
);
router.put(
    '/update/:id',
    profesorCtrl.update
);
router.delete(
    '/:id',
    profesorCtrl.remove
);
//para busqueda por celular
router.get(
    '/searchcel/:celular',
    profesorCtrl.searchcel
);
//para busqueda por correo
router.get(
    '/searchemail/:correo',
    profesorCtrl.searchemail
);
//para busqueda por documento
router.get(
    '/searchdoc/:documento',
    profesorCtrl.searchdoc
);
//para login con solo correo y una contra
router.get(
    '/loginemail/:correo/:contra',
    profesorCtrl.loginemail
);
//para login con solo celular y una contra
router.get(
    '/logincelu/:celular/:contra',
    profesorCtrl.logicel
);
//filtro por grado
router.get(
    '/filter/grado/:grado',
    profesorCtrl.filtergrado
);
//filtro por grado y seccion
router.get(
    '/filter/gradoandseccion/:grado/:seccion',
    profesorCtrl.filtergradoandseccion
);
// solo actualizar la contra
router.put(
    '/updatepass/:id',
    profesorCtrl.updatepass
);

module.exports = router;
