const express = require('express');
const router = express.Router();
const publicacionCtrl = require(
    '../controllers/publicacion.controller'
);

router.get(
    '/',
    publicacionCtrl.list
);
router.get(
    '/:id',
    publicacionCtrl.get
);
router.post(
    '/create',
    publicacionCtrl.create
);
router.put(
    '/update/:id',
    publicacionCtrl.update
);
router.delete(
    '/:id',
    publicacionCtrl.remove
);
// filtrado de libro publicado
router.get(
    '/filter/libro/:libro',
    publicacionCtrl.searchlibro
);
// filtrado por libros hechos por los ninios
router.get(
    '/filter/autor/:autor',
    publicacionCtrl.search
);
// filtrado por procedencia interna o externa
router.get(
    '/filter/procedencia/:procedencia',
    publicacionCtrl.searchproced
);
// filtrado por procedencia interna y por grado a indicar
router.get(
    '/filter/porgrado/:grado',
    publicacionCtrl.searchGradoDestino
);

module.exports = router;
