const express = require('express');
const router = express.Router();
const resolucionCtrl = require(
    '../controllers/resolucion.controller'
);

router.get(
    '/',
    resolucionCtrl.list
);
router.get(
    '/:id',
    resolucionCtrl.get
);
router.post(
    '/create',
    resolucionCtrl.create
);
router.put(
    '/update/:id',
    resolucionCtrl.update
);
router.delete(
    '/:id',
    resolucionCtrl.remove
);
// resolucion de cuestionario
router.get(
    '/filterprogress/:progreso',
    resolucionCtrl.filterbyprogress
);
router.get(
    '/filterprogress/andintento/:progreso/:intento',
    resolucionCtrl.filterbyprogressandnitento
);

module.exports = router;
